#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

enum { ERR_OK, ERR_SOCKET, ERR_BIND, ERR_READ, ERR_WRITE, ERR_INCOMPLETE } ;
char* errors [] = { "Transfer complete\n", "Could not create socket\n",
		    "Could not bind socket\n", "Could not read\n", 
		    "Could not write\n", "Incomplete write\n" } ;
char sending [] = "SENDING stdin to socket\n";
char receiving [] = "RECEIVING socket to stdout\n";
char listening [] = "Listening on port ";
char errno [] = "Errno is ";

void write_int(int i) {
  int divisor = 1000000000;
  int nonzero = 0;
  char c;
  if (i<0) { 
    write(2, "-", 1);
    i = -i;
  }
  while (divisor) {
    int digit = i/divisor;
    i = i%divisor;
    divisor /= 10;
    if (digit || nonzero || !divisor) {
      c = '0'+digit;
      write(2, &c, 1);
      nonzero = 1;
    }
  }
  write(2, "\n", 1);
}

void error(int code) {
  write(2,errors[code],strlen(errors[code]));
  if (code) {
    write(2, errno, strlen(errno));
    write_int(errno);
  }
  exit(code);
}

int main (int argc, char* argv[]) {
  int buffer_size = 4096;
  char buffer[buffer_size];
  int read_length, wrote_length;
  int listening_socket, *client_socket;
  int read_fd, write_fd;
  struct sockaddr_in addr;
  int port = 4000;
  
  if (strstr(argv[0], "send")) {
    read_fd = 0;
    client_socket = &write_fd;
    write(2, sending, strlen(sending));
  } else {
    write_fd = 1;
    client_socket = &read_fd;
    write(2, receiving, strlen(receiving));
  }

  listening_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (listening_socket==-1) error(ERR_SOCKET) ;
  do {
    if (port>=5000) error(ERR_BIND) ;
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = htons(++port);
  } while (-1 == bind(listening_socket, 
		      (struct sockaddr*) &addr,
		      sizeof(struct sockaddr_in))) ;

  write(2, listening, strlen(listening));
  write_int(port);
  listen(listening_socket, 1);
  *client_socket = accept(listening_socket, NULL, 0);
  close(listening_socket);

  while (1) {
    read_length = read(read_fd, buffer, buffer_size);
    if (read_length==-1) error(ERR_READ);
    if (read_length==0) break;
    wrote_length = write(write_fd, buffer, read_length);
    if (wrote_length==-1) error(ERR_WRITE);
    if (wrote_length!=read_length) error(ERR_INCOMPLETE);
  }

  error(ERR_OK);
  return 0; /* never reached */
}

